<?php

namespace App\Providers;

use App\Biolink;
use App\Link;
use App\LinkGroup;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';

    /**
     * The path to the "home" route for your application.
     *
     * @var string
     */
    public const HOME = '/';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        Route::bind('link-group', function ($value) {
            if ($this->getCurrentRequest()->method() === 'DELETE') {
                return $value;
            } else {
                if (is_numeric($value)) {
                    return LinkGroup::findOrFail($value);
                } else {
                    return LinkGroup::where('hash', $value)->firstOrFail();
                }
            }
        });
        Route::bind('biolink', function ($value) {
            if ($this->getCurrentRequest()->method() === 'DELETE') {
                return $value;
            } else {
                if (is_numeric($value)) {
                    return Biolink::findOrFail($value);
                } else {
                    return Biolink::where('hash', $value)->firstOrFail();
                }
            }
        });

        Route::bind('link', function ($value) {
            // Delete method allows multiple IDs separated by comma
            if ($this->getCurrentRequest()->method() === 'DELETE') {
                return $value;
            } else {
                return Link::withTrashed()->findOrFail($value);
            }
        });
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();

        $this->mapWebRoutes();

        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/api.php'));
    }
}
